package com.app.yourradioapp593.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;

import com.app.yourradioapp593.Config;
import com.app.yourradioapp593.R;
import com.app.yourradioapp593.database.prefs.SharedPref;
import com.app.yourradioapp593.listener.OnNegativeButtonListener;
import com.app.yourradioapp593.listener.OnPositiveButtonListener;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;

import java.util.Objects;

public class MaterialAlertDialog {

    public static class Builder {

        public Context context;
        public AlertDialog alertDialog;
        public String title = "";
        public String message = "";
        public boolean cancelable;
        public int textSize = 16;
        public TextView textView;
        public OnPositiveButtonListener onPositiveButtonListener;
        public OnNegativeButtonListener onNegativeButtonListener;

        public Builder(Context context) {
            this.context = context;
            this.textView = new TextView(context);
        }

        public Builder build() {
            loadProgressDialog();
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setCancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder setTextSize(int textSize) {
            this.textSize = textSize;
            return this;
        }

        public Builder setOnPositiveButtonListener(OnPositiveButtonListener onPositiveButtonListener) {
            this.onPositiveButtonListener = onPositiveButtonListener;
            return this;
        }

        public Builder setOnNegativeButtonListener(OnNegativeButtonListener onNegativeButtonListener) {
            this.onNegativeButtonListener = onNegativeButtonListener;
            return this;
        }

        @SuppressLint("RtlHardcoded")
        public void loadProgressDialog() {
            LayoutInflater layoutInflater = LayoutInflater.from(context);
            View rootView = layoutInflater.inflate(R.layout.dialog_custom, null);
            MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(context);
            builder.setView(rootView);

            builder.setTitle(title);
            builder.setMessage(message);
            builder.setCancelable(cancelable);
            alertDialog = builder.create();

            LinearLayout lytButton = rootView.findViewById(R.id.lyt_button);
            Button btnPositive = rootView.findViewById(R.id.btn_positive);
            Button btnNegative = rootView.findViewById(R.id.btn_negative);

            btnPositive.setOnClickListener(view -> Tools.postDelayed(() -> {
                onPositiveButtonListener.onPositive();
                alertDialog.dismiss();
            }, Constant.DELAY_ACTION_CLICK));

            btnNegative.setOnClickListener(view -> Tools.postDelayed(() -> {
                onNegativeButtonListener.onNegative();
                alertDialog.dismiss();
            }, Constant.DELAY_ACTION_CLICK));

            SharedPref sharedPref = new SharedPref(context);
            if (sharedPref.getIsDarkTheme()) {
                btnPositive.setTextColor(ContextCompat.getColor(context, R.color.color_white));
                btnNegative.setTextColor(ContextCompat.getColor(context, R.color.color_white));
            } else {
                btnPositive.setTextColor(ContextCompat.getColor(context, R.color.color_light_primary));
                btnNegative.setTextColor(ContextCompat.getColor(context, R.color.color_light_primary));
            }

            if (Config.ENABLE_RTL_MODE) {
                lytButton.setGravity(Gravity.LEFT);
                Objects.requireNonNull(alertDialog.getWindow()).getDecorView().setLayoutDirection(View.LAYOUT_DIRECTION_RTL);
            } else {
                lytButton.setGravity(Gravity.RIGHT);
                Objects.requireNonNull(alertDialog.getWindow()).getDecorView().setLayoutDirection(View.LAYOUT_DIRECTION_LTR);
            }
            alertDialog.show();
        }

    }

}